
function listarUsuarios(paginador) {


        $.ajax({
        url: "../api/usuarioListar.php",
        type: "POST",
        data: "paginador="+paginador,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                var novaLinha="";

                function percorreElementos(elemento){
                    
                    

                    novaLinha += "<tr id='R"+elemento.id+"'>";
                    novaLinha += "<td>"+elemento.id+"</td>";
                    novaLinha += "<td id='N"+elemento.id+"'>"+elemento.nome+"</td>";
                    novaLinha += "<td>"+elemento.login+"</td>";
                    
                    if (elemento.ativo == 'S') novaLinha += "<td class='d-flex justify-content-center'><span class='btn btn-block btn-outline-success btn-xs' style='width:30px;'>s</span></td>";
                    else novaLinha += "<td class='d-flex justify-content-center'><span class='btn btn-block btn-outline-danger btn-xs' style='width:30px;'>n</span></td>";

                    novaLinha += "<td>"+botaoEditar.replace("<#conteudo#>", "usuarioEditar("+elemento.id+")")+"&nbsp;";
                    novaLinha += botaoExcluir.replace("<#conteudo#>", "usuarioExcluirConfirmacao("+elemento.id+")");+"</td>";
                    novaLinha += "</tr>";
                    
                    $("#listaUsuarios").append(novaLinha);

                    novaLinha = "";
                }
                dataServer.usuarios.forEach(percorreElementos);
            }

            $('#listaUsuarios').DataTable( {
                "dom": 'Bfrtip',
                "buttons": [
                    'colvis',
                    'excel',
                    'pdf',
                    'print'
                ],
                "language": {"url": "./inc/DataTable-pt-BR.json"},
                "responsive" : true,
                "lengthChange": false,
                "autoWidth": false,
                "pageLength": 100,
                "order": []
            } );   

            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}


function usuarioExcluirConfirmacao(id){
    
    $("#modalExclusaoMensagem").text('Deseja excluir o usuário "'+$("#N"+id).text()+'"?'); 
    $("#modalExclusaoBotao").attr("onclick", "usuarioExcluir("+id+")");
    $('#modalExclusao').modal('show');
    
}


function usuarioExcluir(id){
    
    $('#modalExclusao').modal('hide');
    $.ajax({
        url: "../api/usuarioExcluir.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            if (dataServer.retorno == 1){

                 $("#R"+id).fadeOut(400); 
                 toastr.success('Registro excluido com sucesso.');
                
            }
            else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
        }

    });
    
}


function usuarioNovo(){
    carregaPagina('usuarioNovoForm');
}

function usuarioSalvar(){

    loader('on');

    if ($('[name="nome"]').val() == '') {toastr.warning('O campo nome não pode ser vazio, ATENÇÃO!'); loader('off');}
    else if ($('[name="login"]').val() == '') {toastr.warning('O campo login não pode ser vazio', 'ATENÇÃO!'); loader('off');}
    else if ($('[name="senha"]').val() == '') {toastr.warning('A senha não pode ser vazia', 'ATENÇÃO!'); loader('off');}
    else if ($('[name="senha"]').val() != $('[name="senha2"]').val()) {toastr.error('As senhas não são iguais', 'ATENÇÃO!'); loader('off');}
    else{

            var data = $("#formUsuario").serialize();

            $.ajax({
                url: "../api/usuarioSalvar.php",
                type: "POST",
                data: data,
                dataType: "json",
                cache: false,
                success: function(dataServer){
                    
                    if (dataServer.retorno == 1) {
                        toastr.success('Registro criado com sucesso.');
                        carregaPagina('usuarios');
                    }
                    else if (dataServer.retorno == -2)toastr.error('O login já está sendo utilizado por outro usuário!', 'ATENÇÃO!');
                    else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 

                    loader('off');
                    
                },
                error: function(){
                    toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
                }

            });
        }
}



function usuarioEditar(id){
    carregaPagina('usuarioEditarForm', id);
}



function carregaDadosUsuario(id) {


        $.ajax({
        url: "../api/usuarioDados.php",
        type: "POST",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            
            if (dataServer.retorno == 1){ 

                    $("[name='id']").val(dataServer.usuarios[0].id);
                    $("[name='nome']").val(dataServer.usuarios[0].nome);
                    $("[name='login']").val(dataServer.usuarios[0].login);
                    $("[name='status']").val(dataServer.usuarios[0].status);
                    $("[name='senha']").val("########");
                    $("[name='senha2']").val("########");  
            }
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}