function listarOfertas(paginador) {


        $.ajax({
        url: "../api/ofertaListar.php",
        type: "POST",
        data: "paginador="+paginador,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                var novaLinha="";

                function percorreElementos(elemento){
                    
                    

                    novaLinha += "<tr id='R"+elemento.id+"'>";
                    novaLinha += "<td>"+elemento.id+"</td>";
                    novaLinha += "<td id='N"+elemento.id+"'>"+elemento.titulo+"</td>";
                    novaLinha += "<td>"+elemento.empresa+"</td>";
                    novaLinha += "<td>"+elemento.validade+"</td>";
                    novaLinha += "<td>"+elemento.cupons;

                    if (elemento.cupons > 0) novaLinha += "<a href='javascript:cuponsOferta("+elemento.id+")' style='margin-left: 20px;'><span class ='far fa-images'><span></a>";
                    
                    novaLinha +="</td>";
                    
                    if (tipoUsuario=="A") novaLinha += "<td>"+elemento.valor_servico+"<br>"+elemento.desconto+"</td>";

                    if (elemento.ativo == 'S') novaLinha += "<td class='d-flex justify-content-center'><span class='btn btn-block btn-outline-success btn-xs' style='width:30px;'>s</span></td>";
                    else novaLinha += "<td class='d-flex justify-content-center'><span class='btn btn-block btn-outline-danger btn-xs' style='width:30px;'>n</span></td>";

                    novaLinha += "<td>"+botaoEditar.replace("<#conteudo#>", "ofertaEditar("+elemento.id+")")+"&nbsp;";
                    novaLinha += botaoExcluir.replace("<#conteudo#>", "ofertaExcluirConfirmacao("+elemento.id+")");+"</td>";
                    novaLinha += "</tr>";
                    
                    $("#listaOfertas").append(novaLinha);

                    novaLinha = "";
                }
                dataServer.ofertas.forEach(percorreElementos);
            }

            $('#listaOfertas').DataTable( {
                "dom": 'Bfrtip',
                "buttons": [
                    'colvis',
                    'excel',
                    'pdf',
                    'print'
                ],
                "language": {"url": "./inc/DataTable-pt-BR.json"},
                "responsive" : true,
                "lengthChange": false,
                "autoWidth": false,
                "pageLength": 100,
                "order": []
            } );   

            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}

function ofertaExcluirConfirmacao(id){
    
    $("#modalExclusaoMensagem").text('Deseja excluir a oferta "'+$("#N"+id).text()+'"?'); 
    $("#modalExclusaoBotao").attr("onclick", "ofertaExcluir("+id+")");
    $('#modalExclusao').modal('show');
    
}


function ofertaExcluir(id){
    
    $('#modalExclusao').modal('hide');
    $.ajax({
        url: "../api/ofertaExcluir.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            if (dataServer.retorno == 1){

                 $("#R"+id).fadeOut(400); 
                 toastr.success('Registro excluido com sucesso.');
                
            }
            else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
        }

    });
    
}



function ofertaNovo(){
    carregaPagina('ofertaNovoForm');
}

function ofertaSalvar(){

    loader('on');

    if ($('[name="titulo"]').val() == '' || $('[name="descricao"]').val() == '') {toastr.warning('Os campos Titulo e Descrição não podem ser vazios, ATENÇÃO!'); loader('off');}
    else if ($('[name="validade"]').val() == '') {toastr.warning('O campo Validade não pode ser vazio', 'ATENÇÃO!'); loader('off');}
    else if ($('[name="max_utilizacao"]').val() == '') {toastr.warning('O campo Máximo de utilização não pode ser vazio', 'ATENÇÃO!'); loader('off');}
    else if ($('[name="desconto"]').val() == '') {toastr.warning('O campo Desconto não pode ser vazio', 'ATENÇÃO!'); loader('off');}
    else{

            var data = $("#formOferta").serialize();

            $.ajax({
                url: "../api/ofertaSalvar.php",
                type: "POST",
                data: data,
                dataType: "json",
                cache: false,
                success: function(dataServer){
                    
                    if (dataServer.retorno == 1) {
                        toastr.success('Registro criado com sucesso.');
                        carregaPagina('ofertas');
                    }
                    else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 

                    loader('off');
                    
                },
                error: function(){
                    toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
                }

            });
        }
}




function ofertaEditar(id){
    carregaPagina('ofertaEditarForm', id);
}


function carregaDadosOferta(id) {


        $.ajax({
        url: "../api/ofertaDados.php",
        type: "POST",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            
            if (dataServer.retorno == 1){ 

                    $("[name='id']").val(dataServer.ofertas[0].id);
                    $("[name='titulo']").val(dataServer.ofertas[0].titulo);
                    $("[name='descricao']").val(dataServer.ofertas[0].descricao);
                    $("[name='ativo']").val(dataServer.ofertas[0].ativo);
                    $("[name='empresa']").val(dataServer.ofertas[0].empresa);
                    $("[name='validade']").val(dataServer.ofertas[0].validade);
                    $("[name='tipo_desconto']").val(dataServer.ofertas[0].tipo_desconto);
                    $("[name='desconto']").val(dataServer.ofertas[0].desconto);
                    $("[name='max_utilizacao']").val(dataServer.ofertas[0].max_utilizacao);
                    
            }
            else toastr.error('Registro não localizado.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}
