
function listarEstabelecimentos(paginador) {


        $.ajax({
        url: "../api/estabelecimentoListar.php",
        type: "POST",
        data: "paginador="+paginador,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                var novaLinha="";

                function percorreElementos(elemento){
                    
                    

                    novaLinha += "<tr id='R"+elemento.id+"'>";
                    novaLinha += "<td>"+elemento.id+"</td>";
                    novaLinha += "<td id='N"+elemento.id+"'>"+elemento.descricao+"</td>";
                    
                    if (elemento.ativo == 'S') novaLinha += "<td class='d-flex justify-content-center'><span class='btn btn-block btn-outline-success btn-xs' style='width:30px;'>s</span></td>";
                    else novaLinha += "<td class='d-flex justify-content-center'><span class='btn btn-block btn-outline-danger btn-xs' style='width:30px;'>n</span></td>";

                    novaLinha += "<td>"+botaoEditar.replace("<#conteudo#>", "estabelecimentoEditar("+elemento.id+")")+"&nbsp;";
                    novaLinha += botaoExcluir.replace("<#conteudo#>", "estabelecimentoExcluirConfirmacao("+elemento.id+")");+"</td>";
                    novaLinha += "</tr>";
                    
                    $("#listaEstabelecimentos").append(novaLinha);

                    novaLinha = "";
                }
                dataServer.estabelecimentos.forEach(percorreElementos);
            }

            $('#listaEstabelecimentos').DataTable( {
                "dom": 'Bfrtip',
                "buttons": [
                    'colvis',
                    'excel',
                    'pdf',
                    'print'
                ],
                "language": {"url": "./inc/DataTable-pt-BR.json"},
                "responsive" : true,
                "lengthChange": false,
                "autoWidth": false,
                "pageLength": 100,
                "order": []
            } );   

            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}


function estabelecimentoExcluirConfirmacao(id){
    
    $("#modalExclusaoMensagem").text('Deseja excluir o Tipo de Estabelecimento "'+$("#N"+id).text()+'"?'); 
    $("#modalExclusaoBotao").attr("onclick", "estabelecimentoExcluir("+id+")");
    $('#modalExclusao').modal('show');
    
}


function estabelecimentoExcluir(id){
    
    $('#modalExclusao').modal('hide');
    $.ajax({
        url: "../api/estabelecimentoExcluir.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            if (dataServer.retorno == 1){

                 $("#R"+id).fadeOut(400); 
                 toastr.success('Registro excluido com sucesso.');
                
            }
            else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
        }

    });
    
}


function estabelecimentoNovo(){
    carregaPagina('estabelecimentoNovoForm');
}

function estabelecimentoSalvar(){

    loader('on');

    if ($('[name="descricao"]').val() == '') {toastr.warning('O campo Descrição não pode ser vazio, ATENÇÃO!'); loader('off');}
    else{

            var data = $("#formEstabelecimento").serialize();

            $.ajax({
                url: "../api/estabelecimentoSalvar.php",
                type: "POST",
                data: data,
                dataType: "json",
                cache: false,
                success: function(dataServer){
                    
                    if (dataServer.retorno == 1) {
                        toastr.success('Registro criado com sucesso.');
                        carregaPagina('estabelecimentos');
                    }
                    else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 

                    loader('off');
                    
                },
                error: function(){
                    toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
                }

            });
        }
}



function estabelecimentoEditar(id){
    carregaPagina('estabelecimentoEditarForm', id);
}



function carregaDadosEstabelecimento(id) {


        $.ajax({
        url: "../api/estabelecimentoDados.php",
        type: "POST",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            
            if (dataServer.retorno == 1){ 

                    $("[name='id']").val(dataServer.estabelecimentos[0].id);
                    $("[name='descricao']").val(dataServer.estabelecimentos[0].descricao);
                    $("[name='ativo']").val(dataServer.estabelecimentos[0].ativo);
                    
            }
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}