function carregaClientes(paginador) {

    $(".loader").show(); 
    $('#listaClientes').DataTable().destroy();
    $('.clienteLinha').remove();
    var empresa = $("[name='selectEmpresa']").val(); 

    $.ajax({
        url: "../api/clienteListar.php",
        type: "POST",
        data: "empresa="+empresa+"&paginador="+paginador,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                var novaLinha="";

                function percorreElementos(elemento){
                    
                    

                    novaLinha += "<tr id='R"+elemento.id+"' class='clienteLinha'>";
                    novaLinha += "<td>"+elemento.id+"</td>";
                    novaLinha += "<td id='N"+elemento.id+"'>"+elemento.nome+"</td>";
                    novaLinha += "<td id='N"+elemento.id+"'>"+elemento.cpf+"</td>";
                    
                    if (elemento.cadastroApp == 'S') novaLinha += "<td><span class='btn btn-block btn-outline-success btn-xs' style='width:30px;'>s</span></td>";
                    else novaLinha += "<td><span class='btn btn-block btn-outline-danger btn-xs' style='width:30px;'>n</span></td>";

                    if (elemento.ativo == 'S') novaLinha += "<td><span class='btn btn-block btn-outline-success btn-xs' style='width:30px;'>s</span></td>";
                    else novaLinha += "<td><span class='btn btn-block btn-outline-danger btn-xs' style='width:30px;'>n</span></td>";

                    
                    novaLinha += "<td>"+elemento.endereco+"</td>";
                    novaLinha += "<td>"+elemento.numero+"</td>";
                    novaLinha += "<td>"+elemento.complemento+"</td>";
                    novaLinha += "<td>"+elemento.cidade+"</td>";
                    novaLinha += "<td>"+elemento.estado+"</td>";

                    novaLinha += "<td>"+elemento.cep+"</td>";
                    novaLinha += "<td>"+elemento.email+"</td>";
                    novaLinha += "<td>"+elemento.fone+"</td>";
                    novaLinha += "<td>"+elemento.data_nasc+"</td>";
                    novaLinha += "<td>"+elemento.empresa+"</td>";

                    novaLinha += "<td>"+botaoEditar.replace("<#conteudo#>", "clienteEditar("+elemento.id+")")+"&nbsp;";
                    novaLinha += botaoExcluir.replace("<#conteudo#>", "clienteExcluirConfirmacao("+elemento.id+")")+"</td>";
                    

                    novaLinha += "</tr>";
                    
                    $("#listaClientes").append(novaLinha);

                    novaLinha = "";
                }
                dataServer.clientes.forEach(percorreElementos);

            }

            $('#listaClientes').DataTable( {
                    "dom": 'Bfrtip',
                    "buttons": [
                        'colvis',
                        'excel',
                        'pdf',
                        'print'
                    ],
                    "language": {"url": "./inc/DataTable-pt-BR.json"},
                    "responsive" : true,
                    "lengthChange": false,
                    "autoWidth": false,
                    "pageLength": 100,
                    "order": [],
                    "columnDefs": [
                        {"targets": [5],"visible": false,"searchable": true},
                        {"targets": [6],"visible": false,"searchable": true},
                        {"targets": [7],"visible": false,"searchable": true},
                        {"targets": [8],"visible": false,"searchable": true},
                        {"targets": [9],"visible": false,"searchable": true},
                        {"targets": [10],"visible": false,"searchable": true},
                        {"targets": [11],"visible": false,"searchable": true},
                        {"targets": [12],"visible": false,"searchable": true},
                        {"targets": [13],"visible": false,"searchable": true},
                        {"targets": [14],"visible": false,"searchable": true}
                    ]
                } );   


            $(".loader").hide();
            $("#listaClientes").show();
            
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

}


function carregarSelectEmpresas(id,tipo,todas){

    $.ajax({
        url: "../api/empresaCarregarSelect.php",
        type: "GET",
        data: "tipo="+tipo,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            if (dataServer.retorno == 1){

                var novaLinha="<option value='-1'>Selecione uma Empresa</option>";

                if ((todas == "S") && (tipoUsuario == "A"))novaLinha+="<option value='-2'>Todas Empresas</option>";

                function percorreElementos(elemento){
                    
                    novaLinha += "<option value='"+elemento.id+"'>"+elemento.nome_fantasia+"</option>";
                    
                    $("[name='selectEmpresa']").append(novaLinha);

                    novaLinha = "";

                    if ((tipoUsuario == "P") || (tipoUsuario == "C")) id = elemento.id;
                }
                dataServer.empresas.forEach(percorreElementos);
                
            }
            
            $("[name='selectEmpresa']").val(id);
            
            $(".select2").select2({
              tags: true
            });
            $("[role='combobox']").css("height", "39");
            $("[role='presentation']").css("height", "39");

            
            if (id != "-1") carregaClientes();

        },
        error: function(){
            toastr.error('Ocorreu um erro ao carregar as empresas.', 'ERRO!'); 
        }

    });
}

function clienteExcluirConfirmacao(id){
    
    $("#modalExclusaoMensagem").text('Deseja excluir o cliente "'+$("#N"+id).text()+'"?'); 
    $("#modalExclusaoBotao").attr("onclick", "clienteExcluir("+id+")");
    $('#modalExclusao').modal('show');
    
}


function clienteExcluir(id){
    
    $('#modalExclusao').modal('hide');
    $.ajax({
        url: "../api/clienteExcluir.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            if (dataServer.retorno == 1){

                 $("#R"+id).fadeOut(400); 
                 toastr.success('Registro excluido com sucesso.');
                
            }
            else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
        }

    });
    
}


function clienteNovo(){

    if ($("[name='selectEmpresa']").val()==-1) toastr.warning('Selecione uma empresa!, ATENÇÃO!');
    else carregaPagina('clienteNovoForm', $("[name='selectEmpresa']").val());
    
}

function importacaoClientes(){

    if ($("[name='selectEmpresa']").val()==-1) toastr.warning('Selecione uma empresa!, ATENÇÃO!');
    else carregaPagina('clienteImportacao', $("[name='selectEmpresa']").val());
    
}


function clienteCancelar(){
    carregaPagina('clientes',$("[name='id_empresa']").val());
}

function clienteCancelar2(){
    carregaPagina('clientes',$("[name='selectEmpresa']").val());
}


function clienteCancelar3(){
    myDropzone.files = [];
    myDropzone.destroy();
    carregaPagina('clientes',$("[name='selectEmpresa']").val());
}

function clienteSalvar(tipo){

    
    loader('on');


    if ($('[name="nome"]').val() == ''  || $('[name="cpf"]').val() == '') {toastr.warning('O campo Nome e CPF devem ser preenchidos, ATENÇÃO!'); loader('off');}
    else if ($('[name="selectEmpresa"]').val() == '-1') {toastr.warning('É necessário selecionar uma empresa, ATENÇÃO!'); loader('off');}
    else if ($('[name="senha"]').val() == '') {toastr.warning('A senha não pode ser vazia', 'ATENÇÃO!'); loader('off');}
    else if ($('[name="senha"]').val() != $('[name="senha2"]').val()){ toastr.error('As senhas não são iguais', 'ATENÇÃO!'); loader('off');}
    else{

            var data = $("#formCliente").serialize();

            $.ajax({
                url: "../api/clienteSalvar.php",
                type: "POST",
                data: data,
                dataType: "json",
                cache: false,
                success: function(dataServer){
                    
                    if (dataServer.retorno == 1) {
                        toastr.success('Registro criado com sucesso.');
                        carregaPagina('clientes',$("[name='selectEmpresa']").val());
                    }
                    else if (dataServer.retorno == -2) toastr.error('O CPF está sendo usado por '+dataServer.nome+' ID Empresa: '+dataServer.id_empresa, 'ATENÇÃO!');
                    else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 

                    loader('off');
                    
                },
                error: function(){
                    toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
                }

            });
        }
        
}



function clienteEditar(id){
    carregaPagina('clienteEditarForm', id);
}



function carregaDadosCliente(id) {


    $.ajax({
        url: "../api/clienteDados.php",
        type: "POST",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                   $("[name='id']").val(dataServer.clientes[0].id);
                   $("[name='id_empresa']").val(dataServer.clientes[0].id_empresa);
                   $("[name='nome']").val(dataServer.clientes[0].nome); 
                   $("[name='cpf']").val(dataServer.clientes[0].cpf); 
                   $("[name='endereco']").val(dataServer.clientes[0].endereco); 
                   $("[name='numero']").val(dataServer.clientes[0].numero); 
                   $("[name='complemento']").val(dataServer.clientes[0].complemento); 
                   $("[name='cidade']").val(dataServer.clientes[0].cidade); 
                   $("[name='estado']").val(dataServer.clientes[0].estado); 
                   $("[name='cep']").val(dataServer.clientes[0].cep); 
                   $("[name='email']").val(dataServer.clientes[0].email); 
                   $("[name='fone']").val(dataServer.clientes[0].fone); 
                   $("[name='data_nasc']").val(dataServer.clientes[0].data_nasc);
                   $("[name='ativo']").val(dataServer.clientes[0].ativo);
                   $("[name='senha']").val("########");
                   $("[name='senha2']").val("########");  

                   carregarSelectEmpresas(dataServer.clientes[0].id_empresa,'C');

                   
            }
            else toastr.error('Registro não localizado.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}



function clienteImportar() {

    $(".loader").show();

    var formData = new FormData($("#formImportarClientes")[0]);

    $.ajax({
        url: "../api/clienteImportar.php",
        type: "POST",
        data: formData,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                  

                   
            }
            else toastr.error('Registro não localizado.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}

function exibeImportacao(dataServer){

    $('#listaClientes').DataTable().destroy();
    $('.clienteLinha').remove();
    


    var novaLinha="";

    function percorreElementos(elemento){
        
        

        novaLinha += "<tr id='R"+elemento.id+"' class='clienteLinha'>";
        novaLinha += "<td>"+elemento.id+"</td>";
        novaLinha += "<td id='N"+elemento.id+"'>"+elemento.nome+"</td>";
        novaLinha += "<td id='N"+elemento.id+"'>"+elemento.cpf+"</td>";
        
        if (elemento.id_status == 1) {
            novaLinha += "<td><span class='btn btn-block btn-outline-success btn-xs' >"+elemento.status+"</span></td>";
            novaLinha += "<td>"+botaoExcluir.replace("<#conteudo#>", "clienteExcluirConfirmacao("+elemento.id+")")+"</td>";
        }
        else {
            novaLinha += "<td><span class='btn btn-block btn-outline-danger btn-xs' >"+elemento.status+"</span></td>";
            novaLinha += "<td></td>";
        }
        
        novaLinha += "</tr>";
        
        $("#listaClientes").append(novaLinha);

        novaLinha = "";
    }
    dataServer.clientes.forEach(percorreElementos);

            

    $('#listaClientes').DataTable( {
            "dom": 'Bfrtip',
            "buttons": [
                'colvis',
                'excel',
                'pdf',
                'print'
            ],
            "language": {"url": "./inc/DataTable-pt-BR.json"},
            "responsive" : true,
            "lengthChange": false,
            "autoWidth": false,
            "pageLength": 100,
            "order": []
        } );   


  
    $("#exibirClientes").show();
            
            

}

var myDropzone;
var previewNode;
var previewTemplate;

function iniciaDropzone(){

 // DropzoneJS Demo Code Start
  Dropzone.autoDiscover = false

  // Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
  previewNode = document.querySelector("#arquivosUpload")
  previewNode.id = ""
  previewTemplate = previewNode.parentNode.innerHTML
  previewNode.parentNode.removeChild(previewNode)

  if (Dropzone.instances.length > 0){
        myDropzone.files = [];
        myDropzone.destroy();
  }


  myDropzone = new Dropzone(document.body, { // Make the whole body a dropzone
    url: "../api/clienteImportar.php", // Set the url
    params: {'id_empresa':$("[name='selectEmpresa']").val()},
    thumbnailWidth: 80,
    autoProcessQueue : false,
    thumbnailHeight: 80,
    parallelUploads: 1,
    uploadMultiple: false,
    multiple: false,
    previewTemplate: previewTemplate,
    autoQueue: true, 
    previewsContainer: "#previews", 
    clickable: ".fileinput-button",
    acceptedFiles: "text/csv",
    success: function(file, response){
         response = JSON.parse(response);
         if (response.retorno==-1) toastr.error(response.mensagem, 'ERRO!'); 
         else if (response.retorno==1){
                toastr.success(response.mensagem);
                exibeImportacao(response);
         }
    } 
  })

  myDropzone.on("addedfile", function(file) {
    // Hookup the start button
    file.previewElement.querySelector(".start").onclick = function() { myDropzone.enqueueFile(file) }
  })

  // Update the total progress bar
  myDropzone.on("totaluploadprogress", function(progress) {
    document.querySelector(".progress-bar").style.width = progress + "%"
  })

  myDropzone.on("sending", function(file) {
    // Show the total progress bar when upload starts
    //document.querySelector("#total-progress").style.opacity = "1"
    // And disable the start button
    file.previewElement.querySelector(".start").setAttribute("disabled", "disabled")
  })


  // Hide the total progress bar when nothing's uploading anymore
  myDropzone.on("queuecomplete", function(progress) {
    //document.querySelector("#total-progress").style.opacity = "0"
  })

  // Setup the buttons for all transfers
  // The "add files" button doesn't need to be setup because the config
  // `clickable` has already been specified.
  document.querySelector("#actions .start").onclick = function() {
    myDropzone.enqueueFiles(myDropzone.getFilesWithStatus(Dropzone.ADDED))
  }
  document.querySelector("#actions .cancel").onclick = function() {
    myDropzone.removeAllFiles(true)
  }
  // DropzoneJS Demo Code End

}

