<?php

include "../../conexao/conexao.php";
include "../../conexao/configs.php";
include "./includes/funcoes.php";

// Função para obter o token Bearer do Clube de Parcerias
$token = obterBearerTokenClube();

// Array para armazenar o retorno da API
$retorno = array();

if ($token != false) {
    // Recebendo o JSON enviado pelo cliente
    $json = file_get_contents('php://input');
    // Decodificando o JSON para um array associativo do PHP
    $data = json_decode($json, true);

    // Verificando se o campo 'slug' está presente no JSON
    if (isset($data['slug'])) {
        $slug = addslashes($data['slug']);

        // Obtendo a oferta do Clube de Parcerias usando o slug e o token
        $oferta = getOfertaClube($slug, $token);

        // Verificando se a função getOfertaClube retornou dados válidos
        if (!empty($oferta)) {
            $retorno['retorno'] = 1;
            $retorno['offer'] = $oferta;
        } else {
            $retorno['retorno'] = -1;
            $retorno['mensagem'] = "Nenhuma oferta encontrada com o slug informado";
        }
    } else {
        $retorno['retorno'] = -1;
        $retorno['mensagem'] = "Campo 'slug' não foi informado no JSON";
    }
} else {
    $retorno['retorno'] = -1;
    $retorno['mensagem'] = "Não foi possível obter o token do clube de parcerias";
}

// Convertendo o array $retorno para JSON e enviando a resposta
echo json_encode($retorno);
