<?php

function validaToken($id_cliente, $token)
{
    global $db;
    global $retorno;


    $sql = "SELECT * FROM clientes WHERE id= '$id_cliente' ";

    $rs = $db->query($sql);

    if ($rs->num_rows > 0) {

        $dados = $rs->fetch_assoc();

        $id_cliente = $dados['id'];


        if ($dados['token'] != $token) {
            $retorno['retorno'] = -4;
            $retorno['mensagem'] = "Token inválido";
            return false;
        } else if ($dados['ativo'] == "N") {
            $retorno['retorno'] = -1;
            $retorno['mensagem'] = "Cadastro de cliente desativado";
            return false;
        } else return true;
    } else {
        $retorno['retorno'] = -2;
        $retorno['mensagem'] = "Cadastro de cliente inexistente";
        return false;
    }
}

function limpaCampo($campo)
{
    $caracteres = array(".", "/", "-", "_", " ", ",", "\\", "(", ")");

    return str_replace($caracteres, "", $campo);
}


function generateBearerTokenClube()
{
    global $db;
    global $retorno;

    $sql = "SELECT client_id, client_secret  FROM integrations WHERE name = 'clube'";

    $rs = $db->query($sql);

    if ($rs->num_rows > 0) {
        $dados = $rs->fetch_assoc();

        $client_id = $dados['client_id'];
        $client_secret = $dados['client_secret'];

        $token_url = 'https://mosaicoplus.com.br/api-client/v1/auth';
        $data = array(
            'grant_type' => 'client_credentials',
            'client_id' => $client_id,
            'client_secret' => $client_secret,
            'scope' => '*'
        );

        $options = array(
            'http' => array(
                'header' => "Content-Type: application/json\r\n",
                'method' => 'POST',
                'content' => json_encode($data)
            )
        );

        $context = stream_context_create($options);
        $response = file_get_contents($token_url, false, $context);

        if ($response === FALSE) {
            return false; // Failed to fetch token
        }

        $token_data = json_decode($response, true);

        // Step 3: Save the token in the database
        $access_token = $token_data['access_token'];


        $sql = "UPDATE integrations SET bearer_token = '$access_token' WHERE name = 'clube'";

        $rs = $db->query($sql);

        return $access_token;
    } else {
        return false;
    }
}

function obterBearerTokenClube()
{

    global $db;
    global $retorno;

    $sql = "SELECT bearer_token FROM integrations WHERE name = 'clube'";

    $rs = $db->query($sql);

    if ($rs->num_rows > 0) {
        $dados = $rs->fetch_assoc();

        if ($dados['bearer_token'] != null) {
            return $dados['bearer_token'];
        } else {
            $token = generateBearerTokenClube();

            return $token;
        }
    }
}
function getAllOffersCategoria($token, $categoria) {
  
    // Define a URL base
    $baseUrl = 'https://mosaicoplus.com.br/api-client/v1/offers';
    $limit = 50; // Define o limite de ofertas por requisição
    $page = 1; // Começa na página 1
    $all_data = array();

    do {
        // Constroi a URL com os parâmetros de categoria, limite e página
        $url = $baseUrl . '?limit=' . $limit . '&page=' . $page . '&categories[]=' . $categoria;

        // Inicia uma sessão cURL
        $ch = curl_init();

        // Define as opções do cURL
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Accept: application/json",
            "Authorization: Bearer $token"
        ));

        // Executa a requisição
        $response = curl_exec($ch);

        // Verifica se ocorreu algum erro durante a requisição
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            curl_close($ch);
            return ["error" => "Erro ao acessar a URL: " . $error_msg];
        }

        // Fecha a sessão cURL
        curl_close($ch);

        $data = json_decode($response, true);

        // Verifica se a resposta contém mensagem de erro ou erros
        if (isset($data['message']) || isset($data['errors'])) {
            return [
                "error" => "Erro na resposta da API.",
                "message" => $data['message'] ?? "",
                "errors" => $data['errors'] ?? ""
            ];
        }

        // Verifica se a resposta contém dados
        if (isset($data['data'])) {
            $all_data = array_merge($all_data, $data['data']);
        } else {
            return ["error" => "Resposta inválida da API.", "response" => $data];
        }

        // Verifica se a resposta contém metadados
        if (isset($data['meta'])) {
            $currentPage = $data['meta']['currentPage'];
            $totalPages = $data['meta']['pages'];
        } else {
            return ["error" => "Dados de meta ausentes na resposta da API."];
        }

        $page++;

    } while ($page <= $totalPages);

    return $all_data;
}



function getAllOffers($token, $page)
{
    $api_url = 'https://mosaicoplus.com.br/api-client/v1/offers';
    $all_data = array();



    // Constrói a URL da API com o parâmetro de página
    $url = $api_url . "?page=$page";

    // Configuração da requisição
    $options = array(
        'http' => array(
            'header' => "Authorization: Bearer $token\r\n",
            'method' => 'GET'
        )
    );

    $context = stream_context_create($options);
    $response = file_get_contents($url, false, $context);

    if ($response === FALSE) {
        return false;
    }
    $data = json_decode($response, true);

    if (isset($data['data'])) {
        $all_data = array_merge($all_data, $data['data']);
    } else {
        return false;
    }

    $all_data = [
        "pages" => $data['meta']['pages'],
        "currentPage" => $data['meta']['currentPage'],
        "data" => $all_data
    ];

    return $all_data;
}

function getOfertaClube($slug, $token)
{
    $url = 'https://mosaicoplus.com.br/api-client/v1/offers/' . $slug;


    // Configuração da requisição
    $options = array(
        'http' => array(
            'header' => "Authorization: Bearer $token\r\n",
            'method' => 'GET'
        )
    );

    $context = stream_context_create($options);
    $response = file_get_contents($url, false, $context);

    if ($response === FALSE) {
        return false;
    }
    $data = json_decode($response, true);



    return $data;
}

function getLocalidades($token){
    $url = 'https://mosaicoplus.com.br/api-client/v1/locations';
      // Configuração da requisição
      $options = array(
        'http' => array(
            'header' => "Authorization: Bearer $token\r\n",
            'method' => 'GET'
        )
    );

    $context = stream_context_create($options);
    $response = file_get_contents($url, false, $context);

    if ($response === FALSE) {
        return false;
    }
    $data = json_decode($response, true);



    return $data;
}

function getCategorias($token) {
    $baseUrl = 'https://mosaicoplus.com.br/api-client/v1/categories';
    $allCategories = [];
    $currentPage = 1;

    do {
        // Configuração da requisição
        $options = array(
            'http' => array(
                'header' => "Authorization: Bearer $token\r\n",
                'method' => 'GET'
            )
        );

        $context = stream_context_create($options);
        $url = $baseUrl . "?page=" . $currentPage; // Adiciona a página à URL
        $response = file_get_contents($url, false, $context);

        if ($response === FALSE) {
            return false;
        }

        $data = json_decode($response, true);

        if (isset($data['data']) && is_array($data['data'])) {
            $allCategories = array_merge($allCategories, $data['data']);
        }

        // Atualiza informações da paginação
        $meta = isset($data['meta']) ? $data['meta'] : [];
        $currentPage = isset($meta['currentPage']) ? $meta['currentPage'] + 1 : 0;
        $hasNextPage = isset($meta['hasNextPage']) ? $meta['hasNextPage'] : false;

    } while ($hasNextPage);

    return $allCategories;
}
